/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.sct.dao.vo;

import com.quantumdata.sct.dao.impl.XMLDAOFactory;
import com.quantumdata.sct.dao.interfaces.IPersistable;
import com.quantumdata.sct.dao.vo.AbstractCapabilityVO;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;

public class DeviceCapabilityVO
implements IPersistable,
Comparable {
    private boolean isDirty = false;
    private boolean isNew = false;
    private long lastUpdate;
    private String deviceId = null;
    private LinkedHashMap deviceCapabilityElements = new LinkedHashMap();

    public String getDeviceId() {
        return this.deviceId;
    }

    public void setDeviceId(String string) {
        this.deviceId = string;
    }

    public Object getId() {
        return this.deviceId;
    }

    public void setId(Object object) {
        this.deviceId = (String)object;
    }

    public boolean isDirty() {
        return this.isDirty;
    }

    public void setDirty() {
        this.isDirty = false;
    }

    public void setDirty(boolean bl) {
        this.isDirty = bl;
    }

    public boolean isNew() {
        return this.isNew;
    }

    public void setNew() {
        this.isNew = true;
    }

    public void setNew(boolean bl) {
        this.isNew = bl;
    }

    public long getLastUpdate() {
        return this.lastUpdate;
    }

    public void setLastUpdate(long l) {
        this.lastUpdate = l;
    }

    public Collection getDeviceCapabilityElements() {
        return this.deviceCapabilityElements.values();
    }

    public void setDeviceCapabilityElements(Collection collection) {
        this.deviceCapabilityElements.clear();
        for (DeviceCapabilityElementVO deviceCapabilityElementVO : collection) {
            this.deviceCapabilityElements.put(deviceCapabilityElementVO.capabilityId, deviceCapabilityElementVO);
        }
    }

    public int getDeviceCapabilityElementsSize() {
        return this.deviceCapabilityElements.size();
    }

    public void add(DeviceCapabilityElementVO deviceCapabilityElementVO) throws Exception {
        this.deviceCapabilityElements.put(deviceCapabilityElementVO.capabilityId, deviceCapabilityElementVO);
    }

    public int compareTo(Object object) throws ClassCastException {
        return this.deviceId.compareTo(((DeviceCapabilityVO)object).deviceId);
    }

    public void add(AbstractCapabilityVO abstractCapabilityVO, boolean bl) throws Exception {
        DeviceCapabilityElementVO deviceCapabilityElementVO = new DeviceCapabilityElementVO();
        deviceCapabilityElementVO.setCapabilityId((String)abstractCapabilityVO.getId());
        deviceCapabilityElementVO.setMandatory(bl);
    }

    public AbstractCapabilityVO[] getMandatoryCapabilitiesVO() throws Exception {
        LinkedHashMap<String, AbstractCapabilityVO> linkedHashMap = new LinkedHashMap<String, AbstractCapabilityVO>();
        for (DeviceCapabilityElementVO deviceCapabilityElementVO : this.getDeviceCapabilityElements()) {
            if (!deviceCapabilityElementVO.isMandatory()) continue;
            AbstractCapabilityVO abstractCapabilityVO = deviceCapabilityElementVO.getCapabilityVO();
            linkedHashMap.put(deviceCapabilityElementVO.getCapabilityId(), abstractCapabilityVO);
        }
        return this.getAbstractCapabilityArrayFromMap(linkedHashMap);
    }

    public AbstractCapabilityVO[] getNonMandatoryCapabilitiesVO() throws Exception {
        LinkedHashMap<String, AbstractCapabilityVO> linkedHashMap = new LinkedHashMap<String, AbstractCapabilityVO>();
        for (DeviceCapabilityElementVO deviceCapabilityElementVO : this.getDeviceCapabilityElements()) {
            if (deviceCapabilityElementVO.isMandatory()) continue;
            AbstractCapabilityVO abstractCapabilityVO = deviceCapabilityElementVO.getCapabilityVO();
            linkedHashMap.put(deviceCapabilityElementVO.getCapabilityId(), abstractCapabilityVO);
        }
        return this.getAbstractCapabilityArrayFromMap(linkedHashMap);
    }

    public AbstractCapabilityVO[] getAllCapabilityVO() throws Exception {
        LinkedHashMap<String, AbstractCapabilityVO> linkedHashMap = new LinkedHashMap<String, AbstractCapabilityVO>();
        for (DeviceCapabilityElementVO deviceCapabilityElementVO : this.getDeviceCapabilityElements()) {
            linkedHashMap.put(deviceCapabilityElementVO.getCapabilityId(), deviceCapabilityElementVO.getCapabilityVO());
        }
        return this.getAbstractCapabilityArrayFromMap(linkedHashMap);
    }

    private AbstractCapabilityVO[] getAbstractCapabilityArrayFromMap(LinkedHashMap linkedHashMap) {
        AbstractCapabilityVO[] abstractCapabilityVOArray = new AbstractCapabilityVO[linkedHashMap.size()];
        int n = 0;
        Iterator iterator = linkedHashMap.values().iterator();
        while (iterator.hasNext()) {
            abstractCapabilityVOArray[n] = (AbstractCapabilityVO)iterator.next();
            ++n;
        }
        return abstractCapabilityVOArray;
    }

    public static class DeviceCapabilityElementVO
    implements Comparable {
        private boolean mandatory;
        private String capabilityId;

        public boolean isMandatory() {
            return this.mandatory;
        }

        public void setMandatory(boolean bl) {
            this.mandatory = bl;
        }

        public String getCapabilityId() {
            return this.capabilityId;
        }

        public void setCapabilityId(String string) {
            this.capabilityId = string;
        }

        public AbstractCapabilityVO getCapabilityVO() throws Exception {
            return (AbstractCapabilityVO)((Object)XMLDAOFactory.getCapabilityDAO().read(this.capabilityId));
        }

        public void setCapabilityVO(AbstractCapabilityVO abstractCapabilityVO) throws Exception {
            this.capabilityId = (String)abstractCapabilityVO.getId();
        }

        public int compareTo(Object object) throws ClassCastException {
            return this.capabilityId.compareTo(((DeviceCapabilityElementVO)object).capabilityId);
        }
    }
}

